import os,json

files = os.listdir("files")

stats = {}

for f in files :
    print(f)
    with open("files/"+f,encoding="utf-8") as rfile :
        data = json.loads(rfile.read())
        for citation_dict in data :
            # authors
            authors_list = citation_dict["document"]["authors"]
            for a in authors_list :
                try :
                    prénom = a.split()[1]
                    if prénom in stats :
                        stats[prénom] += 1
                    else :  
                        stats[prénom] = 1
                except Exception as e :
                    print ("erreur prénom pour",citation_dict["_id"])

with open("stats_prénoms.csv","w",encoding="utf-8") as wfile :
    for prénom,nombre in stats.items() :
        wfile.write(prénom+"\t"+str(nombre)+"\n")
